import formatInteger from 'utilities/numbers/formatInteger';

import * as i18nBlock from 'i18n/hotels-SearchPageFilters';

export default function getButtonText(
    foundHotelCount: number,
    short: boolean,
): string {
    if (foundHotelCount === 0) {
        return i18nBlock.foundHotel();
    }

    const params = {
        foundHotelCount,
        foundHotelCountLabel: formatInteger(foundHotelCount),
    };

    return short
        ? i18nBlock.foundHotelCountShortNew(params)
        : i18nBlock.foundHotelCountNew(params);
}
