import React, {ReactNode} from 'react';

import {
    EBasicFilterGroupType,
    IBasicFilter,
    IBasicFilterGroup,
    IChangeFilterGroupMeta,
    IChangeFilterGroupPayload,
    TActiveFilterAtomsType,
} from 'types/hotels/search/IFiltersInfo';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import HotelsCheckboxList from '../HotelsCheckboxList/HotelsCheckboxList';
import HotelsRadioBox from '../HotelsRadioBox/HotelsRadioBox';

interface IHotelsFiltersGroupProps extends IWithQaAttributes {
    filterGroup: IBasicFilterGroup;
    onChange: (
        payload: IChangeFilterGroupPayload,
        meta: IChangeFilterGroupMeta,
    ) => void;
    activeFilterAtoms: TActiveFilterAtomsType;
    renderRadioLabel?: (option: IBasicFilter) => ReactNode;
    renderCheckboxLabel?: (option: IBasicFilter) => ReactNode;
}

const HotelsFiltersGroup: React.FC<IHotelsFiltersGroupProps> = ({
    filterGroup,
    activeFilterAtoms,
    onChange,
    renderRadioLabel,
    renderCheckboxLabel,
    ...props
}) => {
    const {items, type, id} = filterGroup;
    const deviceType = useDeviceType();

    if (type === EBasicFilterGroupType.MULTI) {
        return (
            <HotelsCheckboxList
                id={id}
                items={items}
                deviceType={deviceType}
                activeFilterAtoms={activeFilterAtoms}
                onChange={onChange}
                renderCheckboxLabel={renderCheckboxLabel}
                {...prepareQaAttributes(props)}
            />
        );
    }

    if (type === EBasicFilterGroupType.SINGLE) {
        return (
            <HotelsRadioBox
                id={id}
                options={items}
                deviceType={deviceType}
                activeFilterAtoms={activeFilterAtoms}
                onChange={onChange}
                renderRadioLabel={renderRadioLabel}
                {...prepareQaAttributes(props)}
            />
        );
    }

    return null;
};

export default HotelsFiltersGroup;
