import React from 'react';

import {IWithDeviceType} from 'types/withDeviceType';

import {deviceMods} from 'utilities/stylesUtils';

import {priceDescription} from 'i18n/hotels-SearchPageFilters';

import cx from './HotelsFiltersGroups.scss';

interface IHotelsPriceFilterGroupProps extends IWithDeviceType {
    nights: number;
    newDesign?: boolean;
}

const HotelsPriceFilterGroup: React.FC<IHotelsPriceFilterGroupProps> = ({
    deviceType,
    nights,
    newDesign,
    children,
}) => (
    <div
        className={cx('group', 'group_price', deviceMods('group', deviceType), {
            group_newDesign: newDesign,
        })}
    >
        {Boolean(deviceType.isMobile && children && nights) && (
            <div className={cx('groupTitle')}>
                {priceDescription({
                    withPrefix: true,
                    nights,
                })}
            </div>
        )}

        {children}
    </div>
);

export default HotelsPriceFilterGroup;
