import {FC, memo, ReactElement, ReactNode} from 'react';

import {deviceModMobile} from 'utilities/stylesUtils';
import {useDeviceType} from 'utilities/hooks/useDeviceType';

import CheckButton, {
    ICheckButtonProps,
} from 'components/CheckButton/CheckButton';
import {TButtonTheme} from 'components/Button/Button';

import cx from '../../HotelsQuickFilters.scss';

export interface IQuickFilterItemButtonProps {
    name?: string;
    checked: boolean;
    disabled?: boolean;
    className?: string;
    onClick?(): void;
    children?: ReactNode;
    iconLeft?: ReactElement;
    theme?: TButtonTheme;
    size?: ICheckButtonProps['size'];
}

const QuickFilterItemButton: FC<IQuickFilterItemButtonProps> = ({
    name,
    disabled,
    className,
    theme = 'secondary',
    size = 'm',
    ...props
}) => {
    const deviceType = useDeviceType();

    return (
        <CheckButton
            className={cx(
                'filter',
                name && `filter__${name}`,
                disabled && `filter__disabled`,
                deviceModMobile('filter', deviceType),
                className,
            )}
            theme={theme}
            size={size}
            disabled={disabled}
            {...props}
        />
    );
};

export default memo(QuickFilterItemButton);
