import React from 'react';

import {URLs} from 'constants/urls';

import {internalUrl} from 'utilities/url';

import * as i18nBlock from 'i18n/mirCashback';

import Heading from 'components/Heading/Heading';
import Box from 'components/Box/Box';
import cx from 'projects/hotels/components/HotelOfferBadge/HotelOfferBadge.scss';
import Link from 'components/Link/Link';

const MirCashbackPopupContent: React.FC = () => (
    <>
        <Heading level={3}>{i18nBlock.popupTitle()}</Heading>
        <Box above="2" below="2" textSize="m">
            {i18nBlock.disabledMirMobileText()}
        </Box>
        <div className={cx('popupLink')}>
            <Link
                url={internalUrl(URLs.mirCashback)}
                target="_blank"
                rel="noopener noreferrer"
            >
                {i18nBlock.popupLink()}
            </Link>
        </div>
    </>
);

export default MirCashbackPopupContent;
