import {FC, memo} from 'react';

import {useBoolean} from 'utilities/hooks/useBoolean';
import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {deviceModMobile} from 'utilities/stylesUtils';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import * as i18n from 'i18n/hotels-SearchPageFilters';

import {useQuickFilterPrice} from 'projects/hotels/components/HotelsFilters/components/HotelsQuickFilters/hooks/useQuickFilterPrice';
import cx from 'projects/hotels/components/HotelsFilters/components/HotelsQuickFilters/components/Price/Price.scss';
import BottomSheet from 'components/BottomSheet/BottomSheet';
import HotelsPriceFilter from 'projects/hotels/components/HotelsFilters/components/PriceFilter/PriceFilter';
import Button, {TButtonTheme} from 'components/Button/Button';
import Heading from 'components/Heading/Heading';

import PriceFilterButton from './Button';

export interface IBottomSheetPriceFilterButtonProps extends IWithQaAttributes {
    disabled?: boolean;
    theme?: TButtonTheme;
}

const BottomSheetPriceFilterButton: FC<IBottomSheetPriceFilterButtonProps> = ({
    disabled,
    theme = 'primary',
    ...props
}) => {
    const expanded = useBoolean(false);
    const {handleSubmit, handleChange, max, min, value, dirty, currency} =
        useQuickFilterPrice({
            onSubmit: expanded.setFalse,
        });
    const deviceType = useDeviceType();

    return (
        <>
            <PriceFilterButton
                expanded={expanded.value}
                onClick={expanded.toggle}
                disabled={disabled}
            />
            <BottomSheet isOpened={expanded.value} onClose={expanded.setFalse}>
                <div className={cx('root', 'full_width', 'disable_spacing')}>
                    <Heading
                        level={3}
                        weight="bold"
                        className={cx('heading', 'heading_mobile')}
                    >
                        {i18n.price()}
                    </Heading>
                    <HotelsPriceFilter
                        disabled={disabled}
                        currency={currency}
                        value={value}
                        min={min}
                        max={max}
                        onChange={handleChange}
                        className={cx(
                            'price_filter',
                            deviceModMobile('price_filter', deviceType),
                        )}
                    />
                    <Button
                        size="l"
                        theme={theme}
                        disabled={disabled || !dirty}
                        onClick={handleSubmit}
                        className={cx('button', 'full_width')}
                        {...prepareQaAttributes({
                            parent: props,
                            current: 'applyPriceFilter',
                        })}
                    >
                        {i18n.submit()}
                    </Button>
                </div>
            </BottomSheet>
        </>
    );
};

export default memo(BottomSheetPriceFilterButton);
