import {ForwardedRef, forwardRef} from 'react';
import {useSelector} from 'react-redux';

import {quickFiltersPriceSelector} from 'projects/hotels/components/HotelsFilters/components/HotelsQuickFilters/selectors';

import {formatPriceRange} from 'projects/hotels/components/HotelsFilters/components/PriceFilter/utilities/formatPriceRange';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import CheckButton from 'components/CheckButton/CheckButton';
import ArrowBottom from 'icons/16/ArrowBottom';
import {TButtonTheme} from 'components/Button/Button';

import cx from './Price.scss';

export interface IPriceFilterButtonProps extends IWithQaAttributes {
    expanded?: boolean;
    onClick?(): void;
    disabled?: boolean;
    theme?: TButtonTheme;
}

const PriceFilterButton = forwardRef(
    (
        {disabled, expanded, onClick, theme, ...props}: IPriceFilterButtonProps,
        ref: ForwardedRef<HTMLElement>,
    ) => {
        const {
            priceChanged,
            price: {maxValue, minValue, currency, maxPriceEstimate},
        } = useSelector(quickFiltersPriceSelector);

        return (
            <CheckButton
                innerRef={ref}
                checked={priceChanged}
                size="m"
                theme={theme}
                disabled={disabled}
                onClick={onClick}
                iconRight={
                    <ArrowBottom
                        className={cx(
                            'arrow_icon',
                            expanded && 'arrow_icon_open',
                        )}
                    />
                }
                {...prepareQaAttributes(props)}
            >
                {formatPriceRange({
                    currency,
                    max: maxPriceEstimate,
                    min: 0,
                    value: [minValue, maxValue],
                })}
            </CheckButton>
        );
    },
);

PriceFilterButton.displayName = 'PriceFilterButton';

export default PriceFilterButton;
