import {FC, memo, ReactNode} from 'react';

import EPopupDirection from 'components/Popup/types/EPopupDirection';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import {IPopupProps} from 'components/Popup/Popup';
import Dropdown, {IDropdownPopupParams} from 'components/Dropdown/Dropdown';
import {TButtonTheme} from 'components/Button/Button';

import PriceFilterButton from './Button';
import QuickFilterPriceControlForm from './DropdownForm';

export interface IDropdownPriceFilterButtonProps extends IWithQaAttributes {
    disabled?: boolean;
    theme?: TButtonTheme;
}

const POPUP_PROPS: Partial<IPopupProps> = {
    target: 'anchor',
    nonvisual: true,
    directions: [EPopupDirection.BOTTOM_LEFT],
    boundary:
        typeof window === 'undefined' ? undefined : {current: document.body},
    gap: 'small',
    fixPopupInSpring: true,
};
const renderPopup = ({
    meta: {hidePopup},
    componentProps,
}: IDropdownPopupParams): ReactNode => (
    <QuickFilterPriceControlForm
        onSubmit={hidePopup}
        {...prepareQaAttributes(componentProps)}
    />
);

const DropdownPriceFilterButton: FC<IDropdownPriceFilterButtonProps> = ({
    disabled,
    theme,
    ...props
}) => (
    <Dropdown
        popupMotionless
        renderSwitcher={({
            meta: {hidePopup, showPopup, visible},
            input: {ref},
        }): ReactNode => (
            <PriceFilterButton
                ref={ref}
                theme={theme}
                expanded={visible}
                disabled={disabled}
                onClick={visible ? hidePopup : showPopup}
                {...prepareQaAttributes(props)}
            />
        )}
        popupProps={POPUP_PROPS}
        popupComponentProps={prepareQaAttributes(props)}
        renderPopup={renderPopup}
    />
);

export default memo(DropdownPriceFilterButton);
