import {FC, memo} from 'react';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import * as i18n from 'i18n/hotels-SearchPageFilters';

import HotelsPriceFilter from 'projects/hotels/components/HotelsFilters/components/PriceFilter/PriceFilter';
import Text from 'components/Text/Text';
import Flex from 'components/Flex/Flex';
import Button from 'components/Button/Button';
import {useQuickFilterPrice} from 'projects/hotels/components/HotelsFilters/components/HotelsQuickFilters/hooks/useQuickFilterPrice';

import cx from './Price.scss';

// TODO Объединить заголовок в сортировке
// TODO Концепт новых фильтров на мобиле также это затронет
export interface IQuickFilterPriceDropdownFormProps extends IWithQaAttributes {
    disabled?: boolean;
    onSubmit?(): void;
}

const QuickFilterPriceDropdownForm: FC<IQuickFilterPriceDropdownFormProps> = ({
    disabled,
    onSubmit,
    ...props
}) => {
    const {
        handleSubmit,
        handleChange,
        max,
        min,
        value,
        dirty,
        currency,
        changed,
        handleReset,
    } = useQuickFilterPrice({onSubmit});

    return (
        <div className={cx('root')}>
            <Text className={cx('heading')} size="m" weight="normal">
                {i18n.price()}
            </Text>
            <HotelsPriceFilter
                disabled={disabled}
                currency={currency}
                value={value}
                min={min}
                max={max}
                onChange={handleChange}
                className={cx('price_filter')}
            />
            <Flex
                flexDirection="row"
                flexWrap="nowrap"
                inline
                between={2}
                className={cx('buttons')}
            >
                <Button
                    size="m"
                    theme="outlined"
                    disabled={disabled || !changed}
                    onClick={handleReset}
                    className={cx('button')}
                    {...prepareQaAttributes({
                        parent: props,
                        current: 'resetPriceFilter',
                    })}
                >
                    {i18n.reset()}
                </Button>
                <Button
                    size="m"
                    theme="primary"
                    disabled={disabled || !dirty}
                    onClick={handleSubmit}
                    className={cx('button')}
                    {...prepareQaAttributes({
                        parent: props,
                        current: 'applyPriceFilter',
                    })}
                >
                    {i18n.submit()}
                </Button>
            </Flex>
        </div>
    );
};

export default memo(QuickFilterPriceDropdownForm);
