import {FC, memo} from 'react';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import {TButtonTheme} from 'components/Button/Button';

import BottomSheetPriceFilterButton from './BottomSheetButton';
import DropdownPriceFilterButton from './DropdownButton';

export interface IQuickFilterPriceControlProps extends IWithQaAttributes {
    disabled?: boolean;
    theme?: TButtonTheme;
}

const QuickFilterPriceControl: FC<IQuickFilterPriceControlProps> = ({
    disabled,
    theme,
    ...props
}) => {
    const {isMobile} = useDeviceType();

    return isMobile ? (
        <BottomSheetPriceFilterButton
            disabled={disabled}
            {...prepareQaAttributes(props)}
        />
    ) : (
        <DropdownPriceFilterButton
            theme={theme}
            disabled={disabled}
            {...prepareQaAttributes(props)}
        />
    );
};

export default memo(QuickFilterPriceControl);
