import {useDispatch, useSelector} from 'react-redux';
import {useMemo, useState} from 'react';

import {
    changePriceFilter,
    resetPriceFilter,
} from 'reducers/hotels/searchPage/filters/actions';

import {quickFiltersPriceSelector} from 'projects/hotels/components/HotelsFilters/components/HotelsQuickFilters/selectors';

import useDispatchedAction from 'utilities/hooks/useDispatchedAction';
import useImmutableCallback from 'utilities/hooks/useImmutableCallback';
import {CurrencyType} from 'utilities/currency/CurrencyType';

export interface IUseQuickFilterPriceParams {
    onSubmit?(): void;
}

export interface IUseQuickFilterPriceResult {
    min: number;
    max: number;
    value: [number, number];
    currency: CurrencyType;
    /**
     * Можно ли сбрасывать измененное и примененное значение
     */
    changed: boolean;
    /**
     * Значение изменилось, но не применилось
     */
    dirty: boolean;

    handleReset(): void;
    handleChange(value: [number, number]): void;
    handleSubmit(): void;
}

export function useQuickFilterPrice({
    onSubmit,
}: IUseQuickFilterPriceParams): IUseQuickFilterPriceResult {
    const {
        price: {
            minPriceEstimate,
            maxPriceEstimate,
            minValue,
            maxValue,
            currency = CurrencyType.RUB,
        } = {},
        priceChanged,
    } = useSelector(quickFiltersPriceSelector);
    const dispatch = useDispatch();
    const change = useDispatchedAction(changePriceFilter, dispatch);
    const reset = useDispatchedAction(resetPriceFilter, dispatch);

    const [uncommittedValue, setUncommittedValue] = useState<
        [number, number] | null
    >(null);

    const handleResetClick = useImmutableCallback(() => {
        reset({
            targetFiltersType: 'ALL',
        });
        onSubmit?.();
    });
    const handleSubmitClick = useImmutableCallback(() => {
        if (uncommittedValue) {
            setUncommittedValue(null);
            change({
                minValue: uncommittedValue[0],
                maxValue: uncommittedValue[1],
                // TODO Понять, когда не ALL
                targetFiltersType: 'ALL',
            });
        }

        onSubmit?.();
    });

    return useMemo(
        () => ({
            value: uncommittedValue ?? [minValue || 0, maxValue || 0],
            min: minPriceEstimate || 0,
            max: maxPriceEstimate || 0,
            changed: priceChanged,
            dirty: Boolean(uncommittedValue),
            currency,
            handleReset: handleResetClick,
            handleChange: setUncommittedValue,
            handleSubmit: handleSubmitClick,
        }),
        [
            currency,
            uncommittedValue,
            priceChanged,
            minValue,
            maxValue,
            minPriceEstimate,
            maxPriceEstimate,
            handleResetClick,
            handleSubmitClick,
        ],
    );
}
