import {
    IRangePriceFilter,
    TQuickControlTypes,
    TQuickFilter,
} from 'types/hotels/search/IFiltersInfo';

import {StoreInterface} from 'reducers/storeTypes';

import {getHotelsCurrentFilters} from 'selectors/hotels/search/filters/hotelsFiltersSelector';
import {getTotalNights} from 'selectors/hotels/search/searchHotels/getTotalNights';
import deviceTypeSelector from 'selectors/common/deviceTypeSelector';

import createTypedStructuredSelector from 'src/redux/utilities/createTypedStructuredSelector';

const getPriceFilter = (state: StoreInterface): IRangePriceFilter =>
    getHotelsCurrentFilters(state).priceFilter || ({} as IRangePriceFilter);

const getPriceIsChanged = (state: StoreInterface) => {
    const {minPriceEstimate, maxPriceEstimate, maxValue, minValue} =
        getPriceFilter(state);

    return minPriceEstimate !== minValue || maxPriceEstimate !== maxValue;
};

export const activeFilterAtomsSelector = (state: StoreInterface) =>
    getHotelsCurrentFilters(state).activeFilterAtoms;

export const quickFiltersControlsSelector = createTypedStructuredSelector({
    controls(state): TQuickControlTypes[] {
        const {quickControls = [], quickFilters = []} =
            getHotelsCurrentFilters(state);
        const {isMobile} = deviceTypeSelector(state);

        // TODO Удалить quickFilters
        return isMobile && quickControls.length ? quickControls : quickFilters;
    },
    oldFilters(state): TQuickFilter[] {
        return getHotelsCurrentFilters(state).quickFilters ?? [];
    },
});

export const quickFiltersPriceSelector = createTypedStructuredSelector({
    price: getPriceFilter,
    nights: getTotalNights,
    priceChanged: getPriceIsChanged,
});
