import React from 'react';

import {
    EQuickFilterEffect,
    TQuickFilter,
} from 'types/hotels/search/IFiltersInfo';

import MirCardIconDesktop from 'icons/36/MirCard';
import MirCardIconMobile from 'icons/16/MirCard';
import YandexPlusSignColorGradientS from 'icons/illustrations/YandexPlusSignColorGradient/YandexPlusSignColorGradientS';

const DESKTOP_ICON_MAP = {
    [EQuickFilterEffect.YANDEX_PLUS]: {
        iconLeft: <YandexPlusSignColorGradientS />,
    },
    [EQuickFilterEffect.MIR_CASHBACK]: {
        iconLeft: <MirCardIconDesktop width={31} height={10} />,
    },
};

const MOBILE_ICON_MAP = {
    [EQuickFilterEffect.YANDEX_PLUS]: {
        iconLeft: <YandexPlusSignColorGradientS />,
    },
    [EQuickFilterEffect.MIR_CASHBACK]: {
        iconLeft: <MirCardIconMobile width={37} height={16} />,
    },
};

const getItemButtonIconProps = (
    {effect}: TQuickFilter,
    desktop: boolean,
): React.ReactNode =>
    effect && (desktop ? DESKTOP_ICON_MAP : MOBILE_ICON_MAP)[effect];

export default getItemButtonIconProps;
