import React from 'react';

import {
    EQuickFilterEffect,
    TQuickFilter,
} from 'types/hotels/search/IFiltersInfo';

import MirCashbackPopupContent from '../components/MirCashbackPopupContent';

const getItemHint = (
    filter: TQuickFilter,
    desktop: boolean,
): React.ReactNode => {
    const isDisabledMIRonTouch =
        !desktop &&
        !filter.enabled &&
        filter.effect === EQuickFilterEffect.MIR_CASHBACK;

    return isDisabledMIRonTouch ? <MirCashbackPopupContent /> : filter.hint;
};

export default getItemHint;
