import {
    EQuickControlType,
    TQuickControlTypes,
    TQuickFilter,
} from 'types/hotels/search/IFiltersInfo';

function getPatchedQuickControls(
    originalControls: TQuickControlTypes[],
    fallback: TQuickFilter[],
): TQuickControlTypes[] {
    /**
     * Временный костыль до отказа от quickFilters
     * TODO Удалить патчинг, заменить на отрисовку по quickControls без изменений
     */
    const controls = Array.from(
        originalControls.length ? originalControls : fallback,
    );
    const types = controls.map(control => control.type);

    if (!types.includes(EQuickControlType.QUICK_SORT)) {
        controls.push({
            id: 'patched-quick-sort',
            type: EQuickControlType.QUICK_SORT,
            enabled: true,
        });
    }

    if (!types.includes(EQuickControlType.QUICK_FILTER_PRICE)) {
        controls.push({
            id: 'patched-quick-price',
            type: EQuickControlType.QUICK_FILTER_PRICE,
            enabled: true,
            name: 'price',
        });
    }

    return controls;
}

export default getPatchedQuickControls;
