import {FunctionComponent} from 'react';

import {IWithClassName} from 'types/withClassName';

import Flex from 'components/Flex/Flex';
import Skeleton from 'components/Skeletons/Skeleton/Skeleton';

import cx from './MobileHotelsFiltersBarSkeleton.scss';

const MobileHotelsFiltersBarSkeleton: FunctionComponent<IWithClassName> = ({
    className,
}) => {
    return (
        <Flex className={className} between={2} inline>
            <Skeleton withAnimation className={cx('small')} />
            <Skeleton withAnimation className={cx('small')} />
            <Skeleton withAnimation className={cx('big')} />
        </Flex>
    );
};

export default MobileHotelsFiltersBarSkeleton;
