import {ReactElement} from 'react';

/* Components */
import ModalWithBackButton from 'components/ModalWithBackButton/ModalWithBackButton';

/* Component Types */
interface IHotelsFiltersContainer {
    className?: string;
    isVisible: boolean;
    children: ReactElement;
    onClose: () => void;
}

const HotelsFiltersContainer = (
    props: IHotelsFiltersContainer,
): ReactElement => {
    const {isVisible, onClose} = props;

    return (
        <ModalWithBackButton
            isVisible={isVisible}
            onClose={onClose}
            fullScreen
            canRenderBackButton
            resetScrollOnOpen
        >
            {props.children}
        </ModalWithBackButton>
    );
};

export default HotelsFiltersContainer;
