import React from 'react';

import {
    IChangeFilterGroupPayload,
    TQuickFilter,
    TActiveFilterAtomsType,
} from 'types/hotels/search/IFiltersInfo';

import * as i18nBlock from 'i18n/common-filters';
import * as i18nBlockHotel from 'i18n/hotels-SearchPageFilters';

import FiltersBottomSheet from 'components/FiltersBottomSheet/FiltersBottomSheet';
import QuickFiltersPadder from 'components/FiltersBottomSheet/components/QuickFiltersPadder/QuickFiltersPadder';

import MobileHotelsQuickCurtainFilters from '../MobileHotelsQuickCurtainFilters/MobileHotelsQuickCurtainFilters';

interface IMobileHotelsFiltersScrollableSheetProps {
    quickFilters?: TQuickFilter[];
    foundHotelCount?: number;
    onResetAll: () => void;
    onClose: () => void;
    isResetDisabled?: boolean;
    filtersGroupsNode?: React.ReactNode;
    isOpened: boolean;
    activeFilterAtoms: TActiveFilterAtomsType;
    onQuickFilterChange(payload: IChangeFilterGroupPayload): void;
}

const MobileHotelsFiltersScrollableSheet: React.FC<IMobileHotelsFiltersScrollableSheetProps> =
    ({
        onClose,
        onResetAll,
        isResetDisabled,
        foundHotelCount,
        filtersGroupsNode,
        onQuickFilterChange,
        isOpened,
        quickFilters,
    }) => {
        const submitLabel = foundHotelCount
            ? i18nBlockHotel.showVariants({count: foundHotelCount})
            : i18nBlockHotel.noVariants();

        return (
            <FiltersBottomSheet
                isOpened={isOpened}
                onClose={onClose}
                header={i18nBlock.title()}
                onReset={onResetAll}
                resetButtonDisabled={Boolean(isResetDisabled)}
                submitLabel={submitLabel}
                onSubmit={onClose}
                submitButtonDisabled={foundHotelCount === 0}
                contentPadding="none"
            >
                {quickFilters && (
                    <QuickFiltersPadder>
                        <MobileHotelsQuickCurtainFilters
                            onChange={onQuickFilterChange}
                        />
                    </QuickFiltersPadder>
                )}

                {filtersGroupsNode}
            </FiltersBottomSheet>
        );
    };

export default MobileHotelsFiltersScrollableSheet;
