import React, {useCallback} from 'react';

import {
    IChangeFilterGroupPayload,
    TQuickFilter,
} from 'types/hotels/search/IFiltersInfo';
import {EHotelsGoal} from 'utilities/metrika/types/goals/hotels';

import {reachGoal} from 'utilities/metrika';

import HotelsQuickFilters from 'projects/hotels/components/HotelsFilters/components/HotelsQuickFilters/HotelsQuickFilters';

interface IMobileHotelsQuickCurtainFiltersProps {
    onChange(payload: IChangeFilterGroupPayload): void;
}

const MobileHotelsQuickCurtainFilters: React.FC<IMobileHotelsQuickCurtainFiltersProps> =
    ({onChange}) => {
        const handleChange = useCallback(
            (payload: TQuickFilter): void => {
                reachGoal(EHotelsGoal.SEARCH_PAGE_FILTERS_QUICK_FILTER_CLICK);

                onChange(payload);
            },
            [onChange],
        );

        return (
            <HotelsQuickFilters
                size="l"
                onChange={handleChange}
                withPrice={false}
                withSort={false}
            />
        );
    };

export default MobileHotelsQuickCurtainFilters;
