import {CurrencyType} from 'utilities/currency/CurrencyType';
import {formatPrice} from 'utilities/currency';

import * as i18nBlock from 'i18n/hotels-SearchPageFilters';
import * as i18nCommon from 'i18n/common-filters';

export interface IFormatPriceRangeParams {
    currency: CurrencyType;
    value: [number | undefined, number | undefined];
    min: number;
    max: number;
}

export function formatPriceRange({
    min,
    max,
    value: [valueFrom = 0, valueTo = 0],
    currency,
}: IFormatPriceRangeParams) {
    const noTo = valueTo >= max;
    const noFrom = valueFrom <= min;

    if (noTo && noFrom) {
        return i18nBlock.price();
    }

    const formattedFrom = formatPrice({
        currency,
        value: valueFrom,
    });
    const formattedTo = formatPrice({
        currency,
        value: valueTo,
    });

    if (noTo) {
        return `${i18nCommon.priceFrom()} ${formattedFrom}`;
    }

    if (noFrom) {
        return `${i18nCommon.priceTo()} ${formattedTo}`;
    }

    return `${formattedFrom} - ${formattedTo}`;
}
