const defaultStep = 1000;
const breakpoints = [
    {max: 20000, step: 50},
    {max: 70000, step: 100},
    {max: 120000, step: 500},
];

export const getRangeStepByDiff = (diff: number) =>
    diff
        ? breakpoints.find(({max}) => diff <= max)?.step ?? defaultStep
        : undefined;

export const getRoundedValueByStep = (value: number, step?: number) =>
    step ? Math.round(value / step) * step : value;

export const getChangedValuesInRange = <T extends number[]>(
    next: T,
    prev: T,
    diff: number,
): T =>
    next.map((value, index) =>
        value === prev[index]
            ? value
            : getRoundedValueByStep(value, getRangeStepByDiff(diff) ?? 1),
    ) as T;
