import React from 'react';

import {IBasicFilter} from 'types/hotels/search/IFiltersInfo';
import {IWithClassName} from 'types/withClassName';

import parseEffect from './utilities/parseEffect';

import Rating from 'components/Rating/Rating';

import cx from './RatingFilterLabel.scss';

interface IRatingFilterLabelProps extends IWithClassName {
    item: IBasicFilter;
}

const RatingFilterLabel: React.FC<IRatingFilterLabelProps> = ({
    item,
    className,
}) => (
    <Rating
        size="s"
        className={cx('rating', className)}
        rating={parseEffect(item.effect)}
        text={item.name}
    />
);

export default RatingFilterLabel;
