import React from 'react';

import {IDevice} from 'reducers/common/commonReducerTypes';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import * as i18nBlock from 'i18n/hotels-SearchPageFilters';

import Button from 'components/Button/Button';
import CornerCounter from 'components/CornerCounter/CornerCounter';
import FilterIcon from 'icons/16/Filter';

import cx from './ToggleFiltersVisibilityButton.scss';

export interface IToggleFiltersVisibilityButtonProps extends IWithQaAttributes {
    deviceInfo: IDevice;
    canRenderFiltersGroups: boolean;
    totalActiveFilters: number;
    onToggleViewFilters: () => void;
}

const ToggleFiltersVisibilityButton: React.FC<IToggleFiltersVisibilityButtonProps> =
    (props: IToggleFiltersVisibilityButtonProps) => {
        const {
            deviceInfo: {isMobile},
            totalActiveFilters,
            onToggleViewFilters,
        } = props;

        return (
            <CornerCounter className={cx('root')} count={totalActiveFilters}>
                <Button
                    theme="secondary"
                    onClick={onToggleViewFilters}
                    icon={<FilterIcon />}
                    size="m"
                    {...prepareQaAttributes(props)}
                >
                    {isMobile ? '' : i18nBlock.toggleFiltersVisibility()}
                </Button>
            </CornerCounter>
        );
    };

export default ToggleFiltersVisibilityButton;
