import {FC, memo} from 'react';

import {ISortViewProps} from 'projects/hotels/components/HotelsSort/types/SortViewProps';

import {useDeviceType} from 'utilities/hooks/useDeviceType';

import HotelsSortBottomSheetView from 'projects/hotels/components/HotelsSort/components/BottomSheetView';
import HotelsSortSelectView, {
    IHotelsSortSelectViewProps,
} from 'projects/hotels/components/HotelsSort/components/SelectView';
import {TButtonTheme} from 'components/Button/Button';

export interface IHotelsSortView
    extends ISortViewProps,
        Pick<IHotelsSortSelectViewProps, 'menuWidth'> {
    size?: 'm' | 'm-inset' | 'l';
    theme?: TButtonTheme;
}

const HotelsSortView: FC<IHotelsSortView> = ({menuWidth, ...props}) => {
    const deviceType = useDeviceType();
    const autoMenuWidth = deviceType.isMobile ? 'fixed' : 'auto';

    return deviceType.isMobile ? (
        <HotelsSortBottomSheetView {...props} />
    ) : (
        <HotelsSortSelectView
            menuWidth={menuWidth ?? autoMenuWidth}
            {...props}
        />
    );
};

export default memo(HotelsSortView);
