import {ComponentType} from 'react';

import {ESortTypeHint} from 'types/hotels/search/ISortInfo';
import {IIconProps} from 'icons/types/icon';

import SortAscendingIconDesktop from 'icons/12/SortAscending';
import SortDescendingIconDesktop from 'icons/12/SortDescending';
import SortAscendingIconMobile from 'icons/16/SortAscending';
import SortDescendingIconMobile from 'icons/16/SortDescending';

export default function getSortGroupIcon(
    hint: ESortTypeHint | null,
    desktop: boolean,
): ComponentType<IIconProps> | null {
    switch (hint) {
        case ESortTypeHint.ascending: {
            return desktop ? SortAscendingIconDesktop : SortAscendingIconMobile;
        }

        case ESortTypeHint.descending: {
            return desktop
                ? SortDescendingIconDesktop
                : SortDescendingIconMobile;
        }

        default: {
            return null;
        }
    }
}
