import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const GreenLeavesIcon = (props: IIconProps): ReactElement => (
    <svg viewBox="0 0 115 80" fill="none" focusable={false} {...props}>
        <g>
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M74.9542 25.2012C76.1517 20.2101 72.9693 14.9388 67.571 13.199C67.5534 13.1933 56.5294 9.64032 56.5294 9.64032C56.3041 10.0609 56.1131 10.5083 55.9614 10.9798C54.663 15.0156 56.7324 19.2954 60.5855 20.57L74.9542 25.2012Z"
                fill="url(#paint0_linear)"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M111.65 73.0156C111.522 69.6172 108.549 66.8276 104.795 66.6885C104.783 66.6881 97.1167 66.4041 97.1167 66.4041C97.0483 66.7128 97.0064 67.0325 96.994 67.3605C96.8874 70.1678 98.9725 72.5252 101.658 72.6454L111.65 73.0156Z"
                fill="url(#paint1_linear)"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M70.0842 65.0537C65.8586 49.5415 49.1809 39.8667 31.7345 43.2319C31.6775 43.2429 -3.95061 50.1152 -3.95061 50.1152C-3.93602 51.6098 -3.78698 53.1265 -3.49368 54.6503C-0.983521 67.6913 11.1441 76.3226 23.6463 74.0104L70.0842 65.0537Z"
                fill="url(#paint2_linear)"
            />
        </g>
        <defs>
            <linearGradient
                id="paint0_linear"
                x1="77.7592"
                y1="16.4826"
                x2="56.4017"
                y2="9.61127"
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#096141" />
                <stop offset="1" stopColor="#19AB71" />
            </linearGradient>
            <linearGradient
                id="paint1_linear"
                x1="111.881"
                y1="66.951"
                x2="97.0309"
                y2="66.3874"
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#096141" />
                <stop offset="1" stopColor="#19AB71" />
            </linearGradient>
            <linearGradient
                id="paint2_linear"
                x1="64.6614"
                y1="36.8807"
                x2="-4.35693"
                y2="50.1655"
                gradientUnits="userSpaceOnUse"
            >
                <stop stopColor="#096141" />
                <stop offset="1" stopColor="#19AB71" />
            </linearGradient>
        </defs>
    </svg>
);

GreenLeavesIcon.defaultProps = {
    width: 81,
    height: 57,
    fill: 'currentColor',
};

export default GreenLeavesIcon;
