import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const MirPercentageIcon = (props: IIconProps): ReactElement => (
    <svg viewBox="0 0 115 50" fill="none" focusable={false} {...props}>
        <path
            d="M31.7338 49.1231H0V40.1916C4.05976 37.1693 7.488 34.4854 10.2847 32.1397C13.1265 29.7941 15.4045 27.6515 17.1186 25.7118C18.8328 23.7721 20.0732 21.9452 20.8401 20.2311C21.6069 18.517 21.9903 16.7352 21.9903 14.8858C21.9903 12.6304 21.3137 10.8711 19.9605 9.60809C18.6523 8.29994 16.8029 7.64587 14.4121 7.64587C12.0214 7.64587 9.72086 8.16462 7.51055 9.20211C5.34535 10.2396 3.29291 11.6154 1.35325 13.3295V4.80404C3.24781 3.36057 5.30024 2.21031 7.51055 1.35325C9.76597 0.451084 12.5176 0 15.7654 0C18.1561 0 20.3439 0.338313 22.3287 1.01494C24.3134 1.64646 26.005 2.59373 27.4034 3.85677C28.8468 5.1198 29.952 6.67604 30.7188 8.52549C31.4857 10.3298 31.8691 12.3823 31.8691 14.6828C31.8691 16.9382 31.418 19.0809 30.5158 21.1107C29.6588 23.1406 28.3281 25.193 26.5237 27.268C24.7645 29.343 22.5091 31.5308 19.7575 33.8313C17.0059 36.0867 13.7581 38.5902 10.0141 41.3419H31.7338V49.1231Z"
            fill="white"
        />
        <path
            d="M52.6959 49.7997C50.215 49.7997 47.937 49.326 45.862 48.3788C43.787 47.4315 42.0053 45.9655 40.5167 43.9807C39.0281 41.9508 37.8553 39.3571 36.9982 36.1995C36.1863 33.0419 35.7803 29.2528 35.7803 24.8322C35.7803 20.4116 36.1863 16.645 36.9982 13.5325C37.8553 10.3749 39.0281 7.80375 40.5167 5.81898C42.0053 3.7891 43.787 2.32308 45.862 1.42091C47.937 0.473638 50.215 0 52.6959 0C55.1318 0 57.3647 0.473638 59.3946 1.42091C61.4695 2.32308 63.2513 3.76655 64.7399 5.75132C66.2285 7.73609 67.3787 10.3073 68.1907 13.4649C69.0026 16.5773 69.4086 20.3213 69.4086 24.6968C69.4086 29.1175 69.0026 32.9066 68.1907 36.0642C67.3787 39.2218 66.2285 41.8155 64.7399 43.8454C63.2513 45.8752 61.4695 47.3864 59.3946 48.3788C57.3647 49.326 55.1318 49.7997 52.6959 49.7997ZM52.6283 42.2215C53.8011 42.2215 54.8386 41.9508 55.7408 41.4095C56.6429 40.8231 57.3872 39.8533 57.9736 38.5C58.56 37.1468 58.9886 35.365 59.2592 33.1547C59.575 30.9444 59.7329 28.1928 59.7329 24.8998C59.7329 21.652 59.575 18.923 59.2592 16.7127C58.9886 14.5024 58.56 12.7206 57.9736 11.3673C57.4323 10.0141 56.7106 9.04424 55.8084 8.45783C54.9514 7.87142 53.9139 7.57821 52.6959 7.57821C51.478 7.57821 50.418 7.87142 49.5158 8.45783C48.6136 9.04424 47.8468 10.0141 47.2153 11.3673C46.6289 12.7206 46.1778 14.5024 45.862 16.7127C45.5914 18.923 45.4561 21.652 45.4561 24.8998C45.4561 28.1928 45.5914 30.9444 45.862 33.1547C46.1778 35.365 46.6289 37.1468 47.2153 38.5C47.8468 39.8533 48.5911 40.8231 49.4481 41.4095C50.3503 41.9508 51.4104 42.2215 52.6283 42.2215Z"
            fill="white"
        />
        <path
            d="M74.1994 49.326L104.851 0.473636H112.158L81.507 49.326H74.1994ZM91.2504 12.8559C91.2504 16.8705 90.3483 19.9605 88.5439 22.1257C86.7847 24.2909 84.3714 25.3735 81.304 25.3735C78.2367 25.3735 75.8008 24.3585 73.9965 22.3287C72.1921 20.2537 71.29 17.1863 71.29 13.1265C71.29 9.02168 72.1921 5.9092 73.9965 3.78911C75.8008 1.6239 78.2367 0.541298 81.304 0.541298C84.3714 0.541298 86.7847 1.57879 88.5439 3.65378C90.3483 5.68366 91.2504 8.75103 91.2504 12.8559ZM78.3269 12.9912C78.3269 15.5173 78.575 17.2991 79.0712 18.3366C79.5673 19.3289 80.3116 19.8251 81.304 19.8251C82.2964 19.8251 83.0407 19.3289 83.5369 18.3366C84.0331 17.2991 84.2812 15.5173 84.2812 12.9912C84.2812 10.42 84.0331 8.63826 83.5369 7.64587C83.0858 6.65349 82.3415 6.1573 81.304 6.1573C80.2665 6.1573 79.4997 6.65349 79.0035 7.64587C78.5524 8.63826 78.3269 10.42 78.3269 12.9912ZM115 36.9438C115 40.9584 114.098 44.0484 112.293 46.2136C110.534 48.3788 108.121 49.4614 105.054 49.4614C102.031 49.4614 99.5955 48.4239 97.746 46.3489C95.9417 44.2739 95.0395 41.2291 95.0395 37.2144C95.0395 33.1096 95.9417 29.9971 97.746 27.877C99.5955 25.7118 102.031 24.6292 105.054 24.6292C108.121 24.6292 110.534 25.6667 112.293 27.7417C114.098 29.7715 115 32.8389 115 36.9438ZM102.076 37.0791C102.076 39.6052 102.325 41.3644 102.821 42.3568C103.362 43.3492 104.106 43.8454 105.054 43.8454C106.091 43.8454 106.858 43.3492 107.354 42.3568C107.85 41.3644 108.098 39.6052 108.098 37.0791C108.098 34.553 107.85 32.7938 107.354 31.8014C106.858 30.7639 106.091 30.2452 105.054 30.2452C104.061 30.2452 103.317 30.7639 102.821 31.8014C102.325 32.7938 102.076 34.553 102.076 37.0791Z"
            fill="white"
        />
    </svg>
);

MirPercentageIcon.defaultProps = {
    width: 115,
    height: 50,
    fill: 'currentColor',
};

export default MirPercentageIcon;
