import React from 'react';

import {URLs} from 'constants/urls';

import Link from 'components/Link/Link';

interface IMirCashbackLandingLinkProps {
    text: string;
}

const MirCashbackLandingLink: React.FC<IMirCashbackLandingLinkProps> =
    props => {
        const {text} = props;

        return (
            <Link url={URLs.mirCashback} target="_blank" theme="brand">
                {text}
            </Link>
        );
    };

export default React.memo(MirCashbackLandingLink);
