import {FunctionComponent} from 'react';

import {ICancellationInfo} from 'types/hotels/offer/IHotelOfferCancellationInfo';
import {IWithClassName} from 'types/withClassName';

import * as i18nBlock from 'i18n/hotels-OfferRefundableRules';

import IncludeIcon from 'icons/16/Include';
import ExcludeIcon from 'icons/16/Exclude';
import TextWithIcon, {TSize} from 'components/TextWithIcon/TextWithIcon';

import cx from './OfferRefundableLabel.scss';

export interface IOfferRefundableLabelProps extends IWithClassName {
    cancellationInfo: ICancellationInfo;
    size: TSize;
}

const OfferRefundableLabel: FunctionComponent<IOfferRefundableLabelProps> =
    props => {
        const {
            className,
            size,
            cancellationInfo: {hasFreeCancellation},
        } = props;

        return (
            <TextWithIcon
                className={cx(
                    {label_refundable: hasFreeCancellation},
                    className,
                )}
                size={size}
                iconLeft={hasFreeCancellation ? IncludeIcon : ExcludeIcon}
                text={
                    hasFreeCancellation
                        ? i18nBlock.freeRuleTitle()
                        : i18nBlock.fullPriceTitle()
                }
            />
        );
    };

export default OfferRefundableLabel;
