import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';
import {IBookOfferCancellationInfo} from 'server/api/HotelsBookAPI/types/IBookOffer';
import EBookOfferRefundableType from 'projects/account/pages/Order/types/EBookOfferRefundableType';

import {CurrencyType} from 'utilities/currency/CurrencyType';

import OfferRefundableRules from './OfferRefundableRules';

export default {
    title: 'Hotels/OfferRefundableRules',
    component: OfferRefundableRules,
} as Meta;

const cancellationInfo: IBookOfferCancellationInfo = {
    refundable: true,
    refundableRules: [
        {
            price: {
                amount: '4500.00',
                currency: CurrencyType.RUB,
            },
            type: EBookOfferRefundableType.SOME_PENALTY,
            endDate: '2022-04-29T11:00:00',
            startDate: '2022-04-28T11:00:00',
        },
        {
            price: {
                // @ts-ignore расхождения в типах с беком (пример из ответа бека)
                amount: null,
                // @ts-ignore расхождения в типах с беком (пример из ответа бека)
                currency: null,
            },
            type: EBookOfferRefundableType.FULL_PRICE,
            // @ts-ignore расхождения в типах с беком (пример из ответа бека)
            endDate: null,
            startDate: '2022-04-29T11:00:00',
        },
    ],
    highlighted: true,
};

export const Simple: TStorybookFunctionComponent = () => (
    <OfferRefundableRules cancellationInfo={cancellationInfo} />
);
