import React, {PureComponent} from 'react';

import {IWithClassName} from 'types/withClassName';
import {
    IBookOfferCancellationInfo,
    IBookOfferRefundableRule,
} from 'server/api/HotelsBookAPI/types/IBookOffer';
import EOfferRefundableTheme from '../../types/EOfferRefundableTheme';

import {getRefundableRuleRenderProps} from '../../../../utilities/getRefundableRule/getRefundableRule';

import Price from 'components/Price/Price';

import cx from './OfferRefundableRulesContent.scss';

export interface IOfferRefundableRulesContentProps extends IWithClassName {
    theme: EOfferRefundableTheme;
    cancellationInfo: IBookOfferCancellationInfo;
}

class OfferRefundableRulesContent extends PureComponent<IOfferRefundableRulesContentProps> {
    static defaultProps = {
        cancellationInfo: {
            refundable: false,
            refundableRules: [],
        },
        theme: EOfferRefundableTheme.WHITE,
    };

    renderRefundableRule = (
        refundableRule: IBookOfferRefundableRule,
        index: number,
    ): React.ReactNode => {
        const {title, date, theme, price} =
            getRefundableRuleRenderProps(refundableRule);

        let amount, currency;

        if (price) {
            ({amount, currency} = price);
        }

        return (
            <div className={cx('rule')} key={index}>
                <div
                    className={cx('ruleTitle', {
                        [`ruleTitle_theme_${theme}`]: theme,
                    })}
                >
                    {title}&nbsp;
                    {typeof amount !== 'undefined' &&
                        typeof currency !== 'undefined' && (
                            <Price value={amount} currency={currency} />
                        )}
                </div>
                <div className={cx('ruleDate')}>{date}</div>
            </div>
        );
    };

    render(): React.ReactNode {
        const {
            className,
            theme,
            cancellationInfo: {refundableRules},
        } = this.props;

        return (
            refundableRules.length > 0 && (
                <div
                    className={cx(
                        'offerRefundableRules',
                        `offerRefundableRules_theme_${theme}`,
                        className,
                    )}
                >
                    {refundableRules.map(this.renderRefundableRule)}
                </div>
            )
        );
    }
}

export default OfferRefundableRulesContent;
