import {FunctionComponent} from 'react';

export interface IPartnerRichContentProps {
    content: string;
    size?: 's' | 'm';
}

import cx from './PartnerRichContent.scss';

const PartnerRichContent: FunctionComponent<IPartnerRichContentProps> = ({
    content,
    size = 's',
}) => {
    return (
        <div className={cx('content', `content_size_${size}`)}>
            <div dangerouslySetInnerHTML={{__html: content}} />
        </div>
    );
};

export default PartnerRichContent;
