import React from 'react';

import {EPromoCodesApplicationType} from 'types/hotels/book/IApplyPromoCodes';

import * as i18nBlock from 'i18n/hotels-BookPriceInfo';

import Link from 'components/Link/Link';

interface IPromoCodeErrorProps {
    status?: EPromoCodesApplicationType;
}

const PromoCodeError: React.FC<IPromoCodeErrorProps> = ({status}) => {
    switch (status) {
        case EPromoCodesApplicationType.EXPIRED:
            return <>{i18nBlock.promocodeDotErrorDotExpired()}</>;
        case EPromoCodesApplicationType.ALREADY_APPLIED:
            return <>{i18nBlock.promocodeDotErrorDotAlreadyApplied()}</>;
        case EPromoCodesApplicationType.NOT_APPLICABLE:
            return <>{i18nBlock.promocodeDotErrorDotNotApplicable()}</>;
        case EPromoCodesApplicationType.NOT_FOUND:
            return <>{i18nBlock.promocodeDotErrorDotNotFound()}</>;
        default:
            return (
                <>
                    {i18nBlock.promocodeDotErrorDotUnknownError()}
                    <Link
                        theme="ghost"
                        url="https://yandex.ru/support/travel/troubleshooting.html"
                        text={i18nBlock.promocodeDotErrorDotUnknownErrorLink()}
                    />
                </>
            );
    }
};

export default PromoCodeError;
