import {FunctionComponent} from 'react';

import {IRoomArea, IRoomBedGroup} from 'types/hotels/offer/IHotelRoom';

import DotSeparator from 'components/DotSeparator/DotSeparator';
import RoomSize from 'projects/hotels/components/RoomSize/RoomSize';
import BedGroups from 'projects/hotels/components/BedGroups/BedGroups';

import cx from './RoomBedGroupsAndSize.scss';

interface IRoomBedGroupsAndSizeProps {
    area?: IRoomArea;
    bedGroups?: IRoomBedGroup[];
}

const RoomBedGroupsAndSize: FunctionComponent<IRoomBedGroupsAndSizeProps> = ({
    area,
    bedGroups,
}) => {
    const roomSizeNode = area ? (
        <RoomSize className={cx('title')} area={area} />
    ) : null;

    if (roomSizeNode) {
        if (bedGroups?.length) {
            return (
                <BedGroups
                    bedClassName={cx('bed')}
                    bedGroups={bedGroups}
                    canViewBedName
                    canViewImage={false}
                    isSeparatorBlock
                >
                    <DotSeparator />
                    {roomSizeNode}
                </BedGroups>
            );
        }

        return roomSizeNode;
    }

    if (bedGroups?.length) {
        return (
            <BedGroups
                bedClassName={cx('bed')}
                bedGroups={bedGroups}
                canViewBedName
                canViewImage={false}
                isSeparatorBlock
            />
        );
    }

    return null;
};

export default RoomBedGroupsAndSize;
