import {FunctionComponent} from 'react';

import {ERoomAreaUnits, IRoomArea} from 'types/hotels/offer/IHotelRoom';
import {IWithClassName} from 'types/withClassName';

import {CHAR_NBSP} from 'utilities/strings/charCodes';

import * as i18nBlock from 'i18n/hotels-HotelPageRooms';

/* Init styles */
import cx from './RoomSize.scss';

/* Types */
export interface IHotelPageRoomSizeProps extends IWithClassName {
    area: IRoomArea;
}

const RoomSize: FunctionComponent<IHotelPageRoomSizeProps> = ({
    className,
    area,
}) => {
    const {value, unit} = area;

    if (unit !== ERoomAreaUnits.SQUARE_METERS) {
        return null;
    }

    return (
        <div className={cx('root', className)}>
            {value}
            {CHAR_NBSP}
            {i18nBlock.roomSize()}
            <div className={cx('sup')}>2</div>
        </div>
    );
};

export default RoomSize;
