import React, {ChangeEvent} from 'react';

import Checkbox from 'components/Checkbox/Checkbox';

import cx from './ProductonOffersCheckbox.scss';

interface IProductionOffersCheckboxProps {
    checked: boolean;
    onChange(e: ChangeEvent<HTMLInputElement>): void;
}

const ProductionOffersCheckbox: React.FC<IProductionOffersCheckboxProps> =
    props => {
        const {checked, onChange} = props;

        return (
            <Checkbox
                className={cx('root')}
                key="productionOffers"
                value="productionOffers"
                size="m"
                checked={checked}
                label="Продовые офферы"
                onChange={onChange}
            />
        );
    };

export default React.memo(ProductionOffersCheckbox);
