import {useEffect, useRef} from 'react';
import {batchActions} from 'redux-batched-actions';
import isEqual from 'lodash/isEqual';

import {isNotNull} from 'types/utilities';
import {ISearchInformation} from 'reducers/hotels/searchInformation/types';

import {
    setHotelsSearchFormAdultsFieldAction,
    setHotelsSearchFormChildrenAgesFieldAction,
    setHotelsSearchFormEndDateFieldAction,
    setHotelsSearchFormStartDateFieldAction,
    setHotelsSearchFormToFieldAction,
} from 'reducers/hotels/searchForm/actions';
import {CustomDispatch} from 'reducers/trains/customDispatch';

import {formatDate} from 'utilities/dateUtils';
import {ROBOT} from 'utilities/dateUtils/formats';

import {ESuggestSource} from 'components/SearchSuggest/SearchSuggest';

export default function useUpdateBySearchInformation(
    searchInformation: ISearchInformation,
    dispatch: CustomDispatch,
): void {
    const prevSearchInformationRef = useRef<ISearchInformation | null>(null);

    useEffect(() => {
        if (isEqual(prevSearchInformationRef.current, searchInformation)) {
            return;
        }

        const {adults, childrenAges, checkinDate, checkoutDate, activeSuggest} =
            searchInformation;

        if (activeSuggest) {
            const {name} = activeSuggest;

            dispatch(
                batchActions(
                    [
                        setHotelsSearchFormToFieldAction({
                            inputValue: name,
                            source: ESuggestSource.SEARCH_CONTEXT,
                            selectedValue: activeSuggest,
                        }),
                        checkinDate
                            ? setHotelsSearchFormStartDateFieldAction(
                                  formatDate(checkinDate, ROBOT),
                              )
                            : null,
                        checkoutDate
                            ? setHotelsSearchFormEndDateFieldAction(
                                  formatDate(checkoutDate, ROBOT),
                              )
                            : null,
                        setHotelsSearchFormAdultsFieldAction(adults),
                        setHotelsSearchFormChildrenAgesFieldAction(
                            childrenAges,
                        ),
                    ].filter(isNotNull),
                ),
            );

            prevSearchInformationRef.current = searchInformation;
        }
    }, [dispatch, searchInformation]);
}
