import {ESearchFormFieldName} from 'components/SearchForm/types';
import {IHotelsSuggest} from 'types/hotels/common/ISearchSuggest';

import {ISuggestValue} from 'components/SearchSuggest/SearchSuggest';

export interface IHotelsSearchFormPointField
    extends ISuggestValue<IHotelsSuggest> {}

export type THotelsSearchFormDateField = string | null;

export interface IHotelsSearchFormValues {
    [ESearchFormFieldName.TO]: IHotelsSearchFormPointField;
    [ESearchFormFieldName.START_DATE]: THotelsSearchFormDateField;
    [ESearchFormFieldName.END_DATE]: THotelsSearchFormDateField;
    adults: number;
    childrenAges: number[];
}

export interface IHotelsSearchFormErrors {
    [ESearchFormFieldName.TO]?: string[];
    [ESearchFormFieldName.START_DATE]?: string[];
    [ESearchFormFieldName.END_DATE]?: string[];
}
