import {MAX_DAYS_RANGE} from 'constants/hotels';

import {
    IHotelsSearchFormErrors,
    IHotelsSearchFormValues,
    THotelsSearchFormDateField,
} from 'projects/hotels/components/SearchForm/types';

import differenceInCalendarDays from 'components/Calendar/utilities/differenceInCalendarDays';

import * as i18nBlock from 'i18n/components';

const isEmptyDate = (date: THotelsSearchFormDateField): boolean => !date;

const isInvalidRangeDates = (
    startDate: THotelsSearchFormDateField,
    endDate: THotelsSearchFormDateField,
): boolean => {
    if (!startDate || !endDate) {
        return false;
    }

    const rangeDaysCount = differenceInCalendarDays(
        new Date(startDate),
        new Date(endDate),
    );

    return rangeDaysCount > MAX_DAYS_RANGE;
};

export function validateDates(
    fieldsValues: IHotelsSearchFormValues,
): IHotelsSearchFormErrors {
    const {startDate, endDate} = fieldsValues;
    const errors: IHotelsSearchFormErrors = {};

    if (isEmptyDate(startDate)) {
        errors.startDate = [
            i18nBlock.hotelsSearchFormDotValidateDotStartDateRequired(),
        ];
    }

    if (isEmptyDate(endDate)) {
        errors.endDate = [
            i18nBlock.hotelsSearchFormDotValidateDotEndDateRequired(),
        ];
    }

    if (isInvalidRangeDates(startDate, endDate)) {
        errors.endDate = [
            i18nBlock.hotelsSearchFormDotValidateDotInvalidRangeDates(),
        ];
    }

    return errors;
}
