import {FunctionComponent} from 'react';

import {IWithClassName} from 'types/withClassName';

import TextSkeleton from 'components/Skeletons/TextSkeleton/TextSkeleton';

/* Styles */
import cx from './SimilarHotelSkeleton.scss';

export interface ISimilarHotelSkeletonProps extends IWithClassName {
    withBorder?: boolean;
    type?: 'default' | 'short';
}

const SimilarHotelSkeleton: FunctionComponent<ISimilarHotelSkeletonProps> = ({
    type = 'default',
    withBorder,
    className,
}) => {
    return (
        <div
            className={cx(
                'root',
                `root_type_${type}`,
                {root_withBorder: withBorder},
                className,
            )}
        >
            <div className={cx('image')} />
            <div className={cx('content')}>
                {type === 'default' ? (
                    <div className={cx('title')} />
                ) : (
                    <TextSkeleton className={cx('titleText')} size="xs" />
                )}
                <div className={cx('about')} />
                {type === 'default' && <div className={cx('price')} />}
            </div>
        </div>
    );
};

export default SimilarHotelSkeleton;
