import React from 'react';

import {IWithDeviceType} from 'types/withDeviceType';
import {IWithClassName} from 'types/withClassName';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';
import {deviceModMobile} from 'utilities/stylesUtils';

import Flex from 'components/Flex/Flex';
import Text from 'components/Text/Text';
import WarningFilled16 from 'icons/16/WarningFilled';
import WarningFilled24 from 'icons/24/WarningFilled';

import cx from './TextAlertBox.scss';

interface ITextAlertBoxProps
    extends IWithDeviceType,
        IWithClassName,
        IWithQaAttributes {
    text?: string;
}

// Плашку оставляем, если вдруг снова придется что-то показать
const TextAlertBox: React.FC<ITextAlertBoxProps> = ({
    deviceType,
    className,
    text,
    ...restProps
}) => {
    const Icon = deviceType.isMobile ? WarningFilled16 : WarningFilled24;

    return (
        <Flex
            className={cx('root', className)}
            flexDirection="row"
            alignItems="center"
            {...prepareQaAttributes(restProps)}
        >
            <Icon className={cx('icon')} />
            <Text
                className={cx('text', deviceModMobile('text', deviceType))}
                size={deviceType.isMobile ? 's' : 'm'}
            >
                {text}
            </Text>
        </Flex>
    );
};

export default TextAlertBox;
