import {
    ITransportStation,
    TransportStationType,
} from 'types/hotels/hotel/ITransportStation';

const stations: ITransportStation[] = [
    {
        id: 'station__10017658',
        type: TransportStationType.METRO,
        name: 'Тропарёво',
        coordinates: {
            lon: 37.474388774,
            lat: 55.646602549,
        },
        distanceMeters: 1168.71,
        distanceText: '1,2 км',
        metroLine: {
            id: '100000099',
            name: 'Сокольническая линия',
            color: '#cc0000',
        },
    },
    {
        id: 'station__9858950',
        type: TransportStationType.METRO,
        name: 'Юго-Западная',
        coordinates: {
            lon: 37.48312439,
            lat: 55.662539249,
        },
        distanceMeters: 1482.87,
        distanceText: '1,5 км',
        metroLine: {
            id: '100000099',
            name: 'Сокольническая линия',
            color: '#cc0000',
        },
    },
    {
        id: 'station__9858829',
        type: TransportStationType.METRO,
        name: 'Коньково',
        coordinates: {
            lon: 37.519289562,
            lat: 55.634742776,
        },
        distanceMeters: 3227.37,
        distanceText: '3,2 км',
        metroLine: {
            id: '100000083',
            name: 'Калужско-Рижская линия',
            color: '#ff7f00',
        },
    },
    {
        id: 'stop__9646904',
        type: TransportStationType.OTHER,
        name: 'Гостиница Салют',
        coordinates: {
            lon: 37.484385387,
            lat: 55.650673213,
        },
        distanceMeters: 288.895,
        distanceText: '290 м',
    },
    {
        id: 'stop__9648454',
        type: TransportStationType.OTHER,
        name: 'Детская больница',
        coordinates: {
            lon: 37.489868083,
            lat: 55.653247624,
        },
        distanceMeters: 570.742,
        distanceText: '570 м',
    },
    {
        id: 'stop__9649386',
        type: TransportStationType.OTHER,
        name: '43-й квартал Юго-Запада',
        coordinates: {
            lon: 37.485256,
            lat: 55.647766,
        },
        distanceMeters: 631.157,
        distanceText: '630 м',
    },
    {
        id: 'stop__9646913',
        type: TransportStationType.OTHER,
        name: '9-й микрорайон Тёплого Стана',
        coordinates: {
            lon: 37.478181555,
            lat: 55.647226441,
        },
        distanceMeters: 824.539,
        distanceText: '820 м',
    },
    {
        id: 'stop__9648944',
        type: TransportStationType.OTHER,
        name: 'Ленинский проспект - Центр детской гематологии',
        coordinates: {
            lon: 37.492694196,
            lat: 55.652021409,
        },
        distanceMeters: 825.472,
        distanceText: '830 м',
    },
];

export default stations;
