export enum EFilterTypes {
    RATINGS = 'ratings',
    STARS = 'stars',
}

export enum EStarFilterIds {
    STARS_NO = 'stars-no',
    STARS_1 = 'stars-1',
    STARS_2 = 'stars-2',
    STARS_3 = 'stars-3',
    STARS_4 = 'stars-4',
    STARS_5 = 'stars-5',
}

const STARS_BY_ID = {
    [EStarFilterIds.STARS_NO]: undefined,
    [EStarFilterIds.STARS_1]: 1,
    [EStarFilterIds.STARS_2]: 2,
    [EStarFilterIds.STARS_3]: 3,
    [EStarFilterIds.STARS_4]: 4,
    [EStarFilterIds.STARS_5]: 5,
};

export function getStarsByFilterId(id: EStarFilterIds): number | undefined {
    return STARS_BY_ID[id];
}
