import React, {Component} from 'react';
import {connect} from 'react-redux';

import {IWithClassName} from 'src/types/withClassName';

import {StoreInterface} from 'reducers/storeTypes';
import {IDevice} from 'reducers/common/commonReducerTypes';

import {
    textSearchInformationSelector,
    IHotelsTextSearchInformation as IHotelsTextSearchInformationStateProps,
} from 'selectors/hotels/search/searchInformation/textSearchInformationSelector';

/* Components */
import {deviceMods} from 'utilities/stylesUtils';
import {prepareQaAttributes} from 'utilities/qaAttributes/qaAttributes';

import MinLoaderTime from 'components/MinLoaderTime/MinLoaderTime';
import BaseHeaderSearchInformation from 'projects/hotels/components/BaseHeaderSearchInformation/BaseHeaderSearchInformation';

import cx from './HotelsSearchInformation.scss';

/* Component Types */
interface IHotelsSearchInformationProps extends IWithClassName {
    deviceType: IDevice;
    onClick: () => void;
}

/* React-redux */

interface IHotelsSearchInformationDispatchProps {}

type THotelsSearchInformationContainerProps = IHotelsSearchInformationProps &
    IHotelsTextSearchInformationStateProps &
    IHotelsSearchInformationDispatchProps;

class HotelsSearchInformationContainer extends Component<THotelsSearchInformationContainerProps> {
    render(): React.ReactNode {
        const {
            className,
            deviceType,
            onClick,
            dates,
            children,
            adults,
            guests,
            geoName,
        } = this.props;

        const isReady = Boolean(geoName);

        return (
            <MinLoaderTime
                componentNode={
                    isReady && (
                        <BaseHeaderSearchInformation
                            className={className}
                            direction={geoName}
                            date={dates}
                            guests={children ? guests : adults}
                            deviceType={deviceType}
                            onClick={onClick}
                            {...prepareQaAttributes('hotels')}
                        />
                    )
                }
                loaderNode={
                    <div
                        className={cx(
                            'skeleton',
                            deviceMods('skeleton', deviceType),
                            className,
                        )}
                    />
                }
                isLoaderNeeded={!isReady}
                minLoaderTime={300}
            />
        );
    }
}

export default connect<
    IHotelsTextSearchInformationStateProps,
    null,
    {},
    StoreInterface
>(textSearchInformationSelector)(HotelsSearchInformationContainer);
