import React from 'react';
import {useLocation} from 'react-router-dom';

import {hotelsDefaultMeta} from 'projects/hotels/constants/hotelsMeta';

import {hotelsURLs} from 'projects/hotels/utilities/urls';

import SocialSharingMeta from 'components/SocialSharingMeta/SocialSharingMeta';

import {DefaultHotelDocumentMeta} from './DefaultHotelDocumentMeta';

export const HotelsSearchMeta: React.FC = () => {
    const location = useLocation();

    return (
        <>
            <DefaultHotelDocumentMeta />
            <SocialSharingMeta
                {...hotelsDefaultMeta}
                url={hotelsURLs.getShareHotelsSearchUrl(location)}
            />
        </>
    );
};
