import _flow from 'lodash/flow';
import {connect} from 'react-redux';

import {IWithWhiteLabelConfig} from 'types/common/whiteLabel/IWithWhiteLabelConfig';
import {IBookUserSelect} from 'types/hotels/book/ICreateOrder';
import {TExperiments} from 'server/providers/experiments/types';

import {
    createOrderActions,
    TCreateOrderRequestActionType,
} from 'reducers/hotels/bookAndPayPage/orderInfo/actions';
import {StoreInterface} from 'reducers/storeTypes';
import {fetchPassengers} from 'reducers/common/passengers/thunk';
import {IBookPromoCodesReducer} from 'reducers/hotels/bookAndPayPage/promoCodesInfo/reducer';

import hotelsBookPayPageSelector from 'selectors/hotels/book/hotelsBookPayPageSelector';

import bookInfoProvider, {
    IBookInfoComponentProps,
} from 'projects/hotels/containers/BookInfoProvider/BookInfoProvider';

import BookPage from './BookPage';

interface IHotelsBookPageStateProps extends IWithWhiteLabelConfig {
    promoCodesInfo: IBookPromoCodesReducer;
    bookUserSelect: IBookUserSelect;
    experiments: TExperiments;
}

const mapStateToProps = (state: StoreInterface): IHotelsBookPageStateProps => ({
    ...hotelsBookPayPageSelector(state),
});

const mapDispatchToProps = {
    createOrder: createOrderActions.request,
    fetchPassengers: fetchPassengers,
};

type TBookPageStateContainer = ReturnType<typeof mapStateToProps>;

interface IBookPageDispatchContainer {
    createOrder: TCreateOrderRequestActionType;
    fetchPassengers: () => void;
}

export type TBookPageContainerProps = TBookPageStateContainer &
    IBookPageDispatchContainer &
    IBookInfoComponentProps;

export default _flow(
    bookInfoProvider({
        canFetchOfferInfo: true,
        canStartOrderPolling: true,
    }),
    connect<
        TBookPageStateContainer,
        IBookPageDispatchContainer,
        {},
        StoreInterface
    >(mapStateToProps, mapDispatchToProps),
)(BookPage);
