import {connect} from 'react-redux';

import {StoreInterface} from 'reducers/storeTypes';

import BookGuestsForm, {IBookGuestsFormOwnProps} from './BookGuestsForm';

const mapStateToProps = (state: StoreInterface) => ({
    passengers: state.common.passengers,
});

type TBookPageStateContainer = ReturnType<typeof mapStateToProps>;

export type TBookPageContainerProps = TBookPageStateContainer;

export default connect<
    TBookPageStateContainer,
    undefined,
    IBookGuestsFormOwnProps,
    StoreInterface
>(mapStateToProps)(BookGuestsForm);
