import React, {ReactNode} from 'react';

import {IWithClassName} from 'types/withClassName';
import {EWhiteLabelPartner} from 'types/common/whiteLabel/EWhiteLabelPartner';

import {useWhiteLabelConfig} from 'utilities/hooks/useWhiteLabelConfig';
import {useDeviceType} from 'utilities/hooks/useDeviceType';

import BookingLayout from 'components/Layouts/BookingLayout/BookingLayout';

import cx from './WhiteLabelBookingCard.scss';

interface IWhiteLabelBookingCardProps extends IWithClassName {
    children: ReactNode;
}

const WhiteLabelBookingCard: React.FC<IWhiteLabelBookingCardProps> = ({
    className,
    children,
}) => {
    const {config: whiteLabelConfig} = useWhiteLabelConfig();
    const {isDesktop} = useDeviceType();

    if (!whiteLabelConfig) {
        return null;
    }

    const {partner, customerNumberBg} = whiteLabelConfig;
    const style = {
        backgroundImage: `url(${customerNumberBg})`,
    };

    return (
        <BookingLayout.Card
            className={cx('card', className, {
                card_partner_s7: partner === EWhiteLabelPartner.S7,
            })}
        >
            <>
                {isDesktop && customerNumberBg && (
                    <div
                        style={style}
                        className={cx('image', {
                            image_partner_s7: partner === EWhiteLabelPartner.S7,
                        })}
                    ></div>
                )}

                {children}
            </>
        </BookingLayout.Card>
    );
};

export default React.memo(WhiteLabelBookingCard);
