import {connect} from 'react-redux';

import {TExperiments} from 'server/providers/experiments/types';
import {IWithWhiteLabelConfig} from 'types/common/whiteLabel/IWithWhiteLabelConfig';

import {
    setBookUserSelectAction,
    TSetBookUserSelectActionType,
} from 'reducers/hotels/bookAndPayPage/bookUserSelectOptions/actions';
import {StoreInterface} from 'reducers/storeTypes';
import {
    estimateDiscountActions,
    TEstimateDiscountActionType,
    resetPromoCodesAction,
    TResetPromoCodesActionType,
} from 'reducers/hotels/bookAndPayPage/promoCodesInfo/actions';
import {IBookPromoCodesReducer} from 'reducers/hotels/bookAndPayPage/promoCodesInfo/reducer';
import {
    getOrderInfoActions,
    TGetOrderInfoActionType,
    removeOrderActions,
    TRemoveOrderActionType,
} from 'reducers/hotels/bookAndPayPage/orderInfo/actions';
import {IPlatformState} from 'reducers/avia/platform/reducer';

import experimentsSelector from 'selectors/common/experimentsSelector';
import {aviaPlatformSelector} from 'selectors/avia/platform/aviaPlatformSelector';
import {whiteLabelConfigSelector} from 'selectors/common/whiteLabelConfigSelector';

import BookPageContent, {IBookPageContentOwnProps} from './BookPageContent';

interface IHotelsBookPageContentStateProps extends IWithWhiteLabelConfig {
    promoCodesInfo: IBookPromoCodesReducer;
    experiments: TExperiments;
    platform: IPlatformState;
}

const mapStateToProps = (
    state: StoreInterface,
): IHotelsBookPageContentStateProps => ({
    promoCodesInfo: state.hotels.bookAndPay.promoCodesInfo,
    experiments: experimentsSelector(state),
    platform: aviaPlatformSelector(state),
    whiteLabelConfig: whiteLabelConfigSelector(state),
});

export interface IBookPageContentDispatchContainer {
    setBookUserSelect: TSetBookUserSelectActionType;
    estimateDiscount: TEstimateDiscountActionType;
    resetPromoCodes: TResetPromoCodesActionType;
    startOrderPolling: TGetOrderInfoActionType;
    removeOrder: TRemoveOrderActionType;
}

const mapDispatchToProps = {
    setBookUserSelect: setBookUserSelectAction,
    estimateDiscount: estimateDiscountActions.request,
    resetPromoCodes: resetPromoCodesAction,
    startOrderPolling: getOrderInfoActions.request,
    removeOrder: removeOrderActions.request,
};

export type TBookPageContentContainerProps = IHotelsBookPageContentStateProps &
    IBookPageContentDispatchContainer;

export default connect<
    IHotelsBookPageContentStateProps,
    IBookPageContentDispatchContainer,
    IBookPageContentOwnProps,
    StoreInterface
>(
    mapStateToProps,
    mapDispatchToProps,
)(BookPageContent);
