import React from 'react';

import {IWithClassName} from 'types/withClassName';

import * as i18nCommonBlock from 'i18n/common-support';

import {useSupportPhone} from 'hooks/useSupportPhone';

import PhoneWithTitle from 'components/PhoneWithTitle/PhoneWithTitle';

const BookSupportPhone: React.FC<IWithClassName> = ({className}) => {
    const supportPhone = useSupportPhone();

    return (
        <PhoneWithTitle
            title={i18nCommonBlock.title()}
            phone={supportPhone}
            className={className}
        />
    );
};

export default BookSupportPhone;
